<?php

namespace App\Models\Tenant;

use App\Models\Tenant\Management\UserProfile\UserProfile;
use App\Models\Tenant\Management\UserProfile\UserProfileRepository;
use Hyn\Tenancy\Traits\UsesTenantConnection;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;

class User extends Authenticatable
{
    use Notifiable, UsesTenantConnection;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name', 'email', 'password',
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password', 'remember_token',
    ];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];

    protected $appends = ["userProfile"];

    public function getuserProfileAttribute()
    {
        if (isset($this->attributes['profile_id'])) {
            $data = new UserProfileRepository();
            $profile = $data->find($this->attributes['profile_id']);
            return $profile['description'];
        }
    }
}
