<?php

namespace App\Models\Tenant\Warehouse\Movement;

use App\Core\ModelsCore;
use App\Models\Tenant\Warehouse\Warehouse\WarehouseRepository;
use App\Models\Tenant\Warehouse\WarehouseConcept\WarehouseConceptRepository;
use Hyn\Tenancy\Traits\UsesTenantConnection;
use Illuminate\Database\Eloquent\Model;

class Movement extends ModelsCore
{
    use UsesTenantConnection;

    protected $table = 'warehouse_movements';


    protected $appends = ["warehouse_description", 'warehouse_concept'];


    public function getwarehouseDescriptionAttribute()
    {
        if (isset($this->attributes['warehouse_id'])) {
            $warehouse = new WarehouseRepository();
            $description = $warehouse->find($this->attributes['warehouse_id']);
            return $description['description'];
        }
    }

    public function getwarehouseConceptAttribute()
    {
        if (isset($this->attributes['warehouseconcept_id'])) {
            $concept = new WarehouseConceptRepository();
            $description = $concept->find($this->attributes['warehouseconcept_id']);
            return $description['description'];
        }
    }
}
