<?php
/**
 * Created by PhpStorm.
 * User: Lenovo-PC
 * Date: 02/07/2020
 * Time: 02:16 AM
 */

namespace App\Models\Tenant\Warehouse\Movement;


use App\Helper\UtilHelper;
use App\Models\Contract\BaseRepositoryInterface;

class MovementRepository implements BaseRepositoryInterface
{

    protected $obj;
    protected $utilHelper;

    public function __construct()
    {
        $this->obj = new Movement();
        $this->utilHelper = new UtilHelper();
    }

    public function model()
    {
        return $this->obj;
    }

    public function all()
    {
        return $this->obj->all();
    }

    public function create(array $attributes)
    {
        $item = new Sale();
        $item->sale_id = $attributes['sale_id'];
        $item->total_amount = $attributes['subtotal'];
        $item->total_paid = $attributes['total'];
        $item->save();
        return $item;
    }

    public function createEntry(array $attributes)
    {

        $get_correlative = $this->utilHelper->createEntryCorrelative();

        $item = new Movement();
        $item->nro_voucher = $get_correlative['nro_voucher'];
        $item->correlative = $get_correlative['correlative'];
        $item->user_id = auth()->user()->id;
        $item->branchoffice_id = $this->utilHelper->getBranchOffice();
        $item->warehouse_id = $attributes['warehouse_id'];
        $item->warehouseconcept_id = $attributes['warehouseconcept_id'];
        $item->date_movement = $attributes['date_movement'];
        $item->reason = $attributes['reason'];
        $item->type_movement = 'E';
        $item->save();
        return $item;
    }

    public function createOutput(array $attributes)
    {

        $get_correlative = $this->utilHelper->createOutputCorrelative();

        $item = new Movement();
        $item->nro_voucher = $get_correlative['nro_voucher'];
        $item->correlative = $get_correlative['correlative'];
        $item->user_id = auth()->user()->id;
        $item->branchoffice_id = $this->utilHelper->getBranchOffice();
        $item->warehouse_id = $attributes['warehouse_id'];
        $item->warehouseconcept_id = $attributes['warehouseconcept_id'];
        $item->date_movement = $attributes['date_movement'];
        $item->reason = $attributes['reason'];
        $item->type_movement = 'S';
        $item->save();
        return $item;
    }

    public function createNewProduct(array $attributes)
    {
        $item = new Movement();
        $item->user_id = auth()->user()->id;
        $item->branchoffice_id = $this->utilHelper->getBranchOffice();
        $item->warehouse_id = $attributes['warehouse_id'];
        $item->date_movement = date('Y-m-d');
        $item->reason = 'INGRESO INICIAL DE PRODUCTO';
        $item->type_movement = 'E';
        $item->is_newproduct = true;
        $item->save();
        return $item;
    }


    public function updated($id, array $attributes)
    {
        // TODO: Implement updated() method.
    }

    public function find($id)
    {
        return $this->obj->find($id);
    }

    public function getEntryLastCheckCorrelative()
    {
        $item = $this->obj
            ->where('branchoffice_id', $this->utilHelper->getBranchOffice())
            ->where('type_movement', 'E')
//            ->where('deleted_at', null)
            ->orderBy('id', 'desc')
            ->first();

        return $item;
    }

    public function getOuputLastCheckCorrelative()
    {
        $item = $this->obj
            ->where('branchoffice_id', $this->utilHelper->getBranchOffice())
            ->where('type_movement', 'S')
//            ->where('deleted_at', null)
            ->orderBy('id', 'desc')
            ->first();

        return $item;

    }

    public function deleted($id)
    {
        $item = $this->obj->find($id);
        $item->delete();
    }

    public function search($text)
    {
        // TODO: Implement search() method.
    }
}