<?php

namespace App\Models\Tenant\Warehouse\MovementDetail;

use App\Core\ModelsCore;
use App\Models\Tenant\Catalog\Product\ProductRepository;
use Hyn\Tenancy\Traits\UsesTenantConnection;
use Illuminate\Database\Eloquent\Model;

class MovementDetail extends ModelsCore
{
    use UsesTenantConnection;

    protected $table = 'warehouse_detailmovements';

    protected $appends = ["product"];

    public function getproductAttribute()
    {
        if (isset($this->attributes['product_id'])) {
            $product = new ProductRepository();
            $description = $product->find($this->attributes['product_id']);
            return $description['description'];
        }
    }
}
