<?php
/**
 * Created by PhpStorm.
 * User: Lenovo-PC
 * Date: 02/07/2020
 * Time: 02:18 AM
 */

namespace App\Models\Tenant\Warehouse\MovementDetail;


use App\Models\Contract\BaseRepositoryInterface;
use Illuminate\Support\Facades\DB;

class MovementDetailRepository implements BaseRepositoryInterface
{

    protected $obj;

    public function __construct()
    {
        $this->obj = new MovementDetail();
    }

    public function model()
    {
        return $this->obj;
    }

    public function all()
    {
        return $this->obj->all();
    }

    public function create(array $attributes)
    {
    }

    public function createEntry(array $attributes)
    {
        $item = new MovementDetail();
        $item->warehousemovement_id = $attributes['warehousemovement_id'];
        $item->warehouse_id = $attributes['warehouse_id'];
        $item->product_id = $attributes['product_id'];
        $item->unitmeasure_id = $attributes['unit_id'];
        $item->quantity = $attributes['quantity'];
        $item->price = $attributes['price'];
        $item->save();
        return $item;
    }

    public function createOutput(array $attributes)
    {
        $item = new MovementDetail();
        $item->warehousemovement_id = $attributes['warehousemovement_id'];
        $item->warehouse_id = $attributes['warehouse_id'];
        $item->product_id = $attributes['product_id'];
        $item->unitmeasure_id = $attributes['unit_id'];
        $item->quantity = $attributes['quantity'];
        $item->price = $attributes['price'];
        $item->save();
        return $item;
    }

    public function createNewProduct(array $attributes)
    {
        $item = new MovementDetail();
        $item->warehousemovement_id = $attributes['warehousemovement_id'];
//        $item->warehouse_id = $attributes['warehouse_id'];
        $item->product_id = $attributes['product_id'];
        $item->quantity = $attributes['stock'];
        $item->price = $attributes['price'];
        $item->save();
        return $item;

    }

    public function updated($id, array $attributes)
    {
        // TODO: Implement updated() method.
    }

    public function find($id)
    {
        // TODO: Implement find() method.
    }

    public function findByMovementIdJoined($movement_id)
    {
        return $this->obj
            ->join('catalog_products', 'warehouse_detailmovements.product_id', '=', 'catalog_products.id')
            ->join('config_unitsofmeasure', 'warehouse_detailmovements.unitmeasure_id', '=', 'config_unitsofmeasure.id')
            ->leftjoin('catalog_productbatch', 'warehouse_detailmovements.productbatch_id', '=', 'catalog_productbatch.id')
            ->select('warehouse_detailmovements.*',
                'catalog_products.description as description',
                'catalog_productbatch.date_expiration as date_expiration',
                'config_unitsofmeasure.description as unitmeasure',
                'warehouse_detailmovements.id as detail_id',
                'warehouse_detailmovements.product_id as id', DB::raw('(warehouse_detailmovements.quantity * warehouse_detailmovements.price) as subtotal'))
            ->where('warehouse_detailmovements.deleted_at', null)
            ->where('warehouse_detailmovements.warehousemovement_id', $movement_id)
            ->get();
    }

    public function getDetailbyMovement($movement_id)
    {
        $query = $this->obj
            ->where('warehousemovement_id', $movement_id)
            ->where('deleted_at', null)
            ->get();

        return $query;
    }

    public function averagePriceMovementProduct($prduct_id){
        $query = $this->obj
            ->join('warehouse_movements', 'warehouse_detailmovements.warehousemovement_id', '=', 'warehouse_movements.id')
            ->selectRaw("
            (SUM(warehouse_detailmovements.price * warehouse_detailmovements.quantity))/
            (SUM(warehouse_detailmovements.quantity * ( CASE WHEN warehouse_detailmovements.equivalence ISNULL THEN 1 ELSE warehouse_detailmovements.equivalence END))) as average_price")
            ->where('warehouse_detailmovements.product_id', $prduct_id)
            ->where('warehouse_detailmovements.deleted_at', null)
            ->where('warehouse_movements.deleted_at', null)
            ->first();

        return $query;
    }

    public function deleted($id)
    {
        // TODO: Implement deleted() method.
    }

    public function search($text)
    {
        // TODO: Implement search() method.
    }
}