<?php
/**
 * Created by PhpStorm.
 * User: Lenovo-PC
 * Date: 30/06/2020
 * Time: 10:54 AM
 */

namespace App\Models\Tenant\Warehouse\Warehouse;


use App\Helper\UtilHelper;
use App\Models\Contract\BaseRepositoryInterface;

class WarehouseRepository implements BaseRepositoryInterface
{

    protected $obj;
    protected $utilHelper;

    public function __construct()
    {
        $this->obj = new Warehouse();
        $this->utilHelper = new UtilHelper();
    }

    public function model()
    {
        return $this->obj;
    }

    public function all()
    {
        return $this->obj->all();
    }

    public function warehousePrincipal()
    {
        $branch_office = $this->utilHelper->getBranchOffice();
        return $this->obj->where('branchoffice_id', $branch_office)->where('is_principal', true)->get();
    }

    public function warehouseBranchOffice()
    {
        $branch_office = $this->utilHelper->getBranchOffice();
        return $this->obj->where('branchoffice_id', $branch_office)->where('deleted_at', null)->get();
    }


    public function create(array $attributes)
    {
        // TODO: Implement create() method.
    }

    public function updated($id, array $attributes)
    {
        // TODO: Implement updated() method.
    }

    public function find($id)
    {
        return $this->obj->find($id);
    }

    public function deleted($id)
    {
        // TODO: Implement deleted() method.
    }

    public function search($text)
    {
        // TODO: Implement search() method.
    }
}