<?php

namespace App\Models\Tenant\Warehouse\WarehouseTransfer;

use App\Core\ModelsCore;
use App\Models\Tenant\Warehouse\Movement\MovementRepository;
use Hyn\Tenancy\Traits\UsesTenantConnection;
use Illuminate\Database\Eloquent\Model;

class WarehouseTransfer extends ModelsCore
{
    use UsesTenantConnection;

    protected $table = 'warehouse_transfers';

    protected $appends = ["code_ouput", 'code_entry'];


    public function getcodeOuputAttribute()
    {
        if (isset($this->attributes['movementouput_id'])) {
            $movement = new MovementRepository();
            $description = $movement->find($this->attributes['movementouput_id']);
            return $description['nro_voucher'];
        }
    }

    public function getcodeEntryAttribute()
    {
        if (isset($this->attributes['movemententry_id'])) {
            $movement = new MovementRepository();
            $description = $movement->find($this->attributes['movemententry_id']);
            return $description['nro_voucher'];
        }
    }
}
