<?php
/**
 * Created by PhpStorm.
 * User: Lenovo-PC
 * Date: 21/02/2021
 * Time: 01:11 PM
 */

namespace App\Models\Tenant\Warehouse\WarehouseTransfer;

use App\Helper\UtilHelper;
use App\Models\Contract\BaseRepositoryInterface;

class WarehouseTransferRepository implements BaseRepositoryInterface
{

    protected $obj;
    protected $utilHelper;

    public function __construct()
    {
        $this->obj = new WarehouseTransfer();
        $this->utilHelper = new UtilHelper();
    }

    public function model()
    {
        return $this->obj;
    }

    public function all()
    {
        return $this->obj->all();
    }

    public function create(array $attributes)
    {
        $get_correlative = $this->utilHelper->createTransferCorrelative();

        $item = new WarehouseTransfer();
        $item->nro_voucher = $get_correlative['nro_voucher'];
        $item->correlative = $get_correlative['correlative'];
        $item->user_id = auth()->user()->id;
        $item->branchoffice_id = $this->utilHelper->getBranchOffice();
        $item->movemententry_id = $attributes['movemententry_id'];
        $item->movementouput_id = $attributes['movementouput_id'];
        $item->warehouseorigin_id = $attributes['warehouseorigin_id'];
        $item->warehousdestiny_id = $attributes['warehousdestiny_id'];
        $item->warehouseconcept_id = $attributes['warehouseconcept_id'];
        $item->date_transfer = $attributes['date_transfer'];
        $item->reason = $attributes['reason'];
        $item->save();
        return $item;
    }


    public function getTransferLastCheckCorrelative()
    {
        $item = $this->obj
            ->where('branchoffice_id', $this->utilHelper->getBranchOffice())
            ->orderBy('id', 'desc')
            ->first();

        return $item;

    }

    public function updated($id, array $attributes)
    {
        // TODO: Implement updated() method.
    }

    public function find($id)
    {
        // TODO: Implement find() method.
    }

    public function deleted($id)
    {
        // TODO: Implement deleted() method.
    }

    public function search($text)
    {
        // TODO: Implement search() method.
    }
}