<?php

return [

    // modo de desarrollo
    'dev_mode' => env('DEV_MODE', false),

    // configuration api service
    'api_service' => env('API_SERVICE', false),
    'api_service_url' => env('API_SERVICE_URL', 'https://apiperu.dev'),
    'api_service_token' => env('API_SERVICE_TOKEN', 'e8593e199a09ccac4c403e6af0de323647e355310faf1dbf27badd5bb2e5876d'),


    // TIPOS DE FACTURACION ELECTRONICA
    'billing_exonerada'=>1,
    'billing_gravada'=>2,

    // configurations profiles user
    'profile_seller' =>2, // perfil usuario de vendedor

    // configuraciones del sistema a partir de la base de datos principal
    'typeproduct_bienes' =>1,
    'typeproduct_servicios' =>2,

    // metodos de pago
    'paymethod_cash'=>1,
    'paymethod_visa'=>2,
    'paymethod_check'=>3,
    'paymethod_deposit'=>4,
    'paymethod_quota'=>5,

    // monedas -> currency
    'currency_sol'=>1,

    // tipo transacciones
    'transaction_cash' => 1,
    'transaction_credit' => 2,

    // configuration apps tenant
    'client_default' =>1, // clientes varios
    'paginate_by' => env('PAGINATE_BY', 10),
    'shift_morning' => 1, // turno mañana
    'shift_afternoon' =>2, // turno tarde

    // config types document
    'typedocument_dni'=>1,
    'typedocument_ruc'=>2,

    // catalogo : tipo de precios
    'catalog_price_general'=>1,
    'catalog_price_unit'=>2,
    'catalog_price_variant'=>3,

    // config type vouchers
    'voucher_boleta_id' => 1,
    'voucher_factura_id' => 2,
    'voucher_creditnote_id' => 3,
    'voucher_debitnote_id' => 4,
    'voucher_proforma_id' => 7,
    'voucher_nota_pedido_id' => 8,
    'voucher_recibo_ingreso_id' => 9,
    'voucher_recibo_egreso_id' => 10,

    'max_monto_boleta_sin_dni'=>700,

    // type money concept
    'tipo_movimiento_ingreso'=>1,
    'tipo_movimiento_egreso'=>2,

    // concept money movements
    'moneyconcept_openbox'=>1,
    'moneyconcept_saleproduct_id'=>2,
    'moneyconcept_repayment_id'=>8,
    'moneyconcept_paycredit'=>9,
    'moneyconcept_paypurchase'=>11,
    'moneyconcept_commision'=>12,
    'moneyconcept_amortization_booking'=>13,

    // warehouse_concepts
    'warehouseconcept_transferentry'=>3,
    'warehouseconcept_transferouput'=>7,

    // format export data
    'export_format_pdf'=>1,
    'export_format_excel'=>2,

    // impresion format
    'impresion_a4'=>"a4",
    'impresion_ticket'=>"ticket",

    'voucher_concretado'=>1,
    'voucher_anulado'=>2,

    'sunat_enviado'=>1,
    'sunat_pendiente'=>2,


    // facturacion configuraciones
    'code_leyenda_bienes_exonerado'=>'2001',
    'txt_leyenda_bienes_exonerado' => 'BIENES TRANSFERIDOS EN LA AMAZONÍA REGIÓN SELVA PARA SER CONSUMIDOS EN LA MISMA',
    'code_leyenda_servicios_exonerado' => '2002',
    'txt_leyenda_servicios_exonerado' => 'SERVICIOS PRESTADOS EN LA AMAZONÍA REGIÓN SELVA PARA SER CONSUMIDOS EN LA MISMA',


    //  name tenant database companies
    'database_nakaes'=>'sisturing_bdnakaescorp',
    'database_tatohito'=>'sisturing_bdlabtatohito',
    'database_arilith'=>'sisturing_bdarelithyurimaguas',
    'database_hostingnet'=>'idSdanR0NW',

    'database_joyeriangel'=>'23CYOyILqp',
    //    'database_joyeriangel'=>'H7sdAFBfFd',
    'database_novedadesrosita' => 'JJPWYPLMY6',

    // APP VARIABLES
    'domain' => env('APP_DOMAIN', 'laravel.com'),
    'is_maintenance'=>false,

    /*
    |--------------------------------------------------------------------------
    | Application Name
    |--------------------------------------------------------------------------
    |
    | This value is the name of your application. This value is used when the
    | framework needs to place the application's name in a notification or
    | any other location as required by the application or its packages.
    |
    */

    'name' => env('APP_NAME', 'Laravel'),
    'base_url' => env('BASE_URL', 'http://'),

    /*
    |--------------------------------------------------------------------------
    | Application Environment
    |--------------------------------------------------------------------------
    |
    | This value determines the "environment" your application is currently
    | running in. This may determine how you prefer to configure various
    | services the application utilizes. Set this in your ".env" file.
    |
    */

    'env' => env('APP_ENV', 'production'),

    /*
    |--------------------------------------------------------------------------
    | Application Debug Mode
    |--------------------------------------------------------------------------
    |
    | When your application is in debug mode, detailed error messages with
    | stack traces will be shown on every error that occurs within your
    | application. If disabled, a simple generic error page is shown.
    |
    */

    'debug' => env('APP_DEBUG', false),

    /*
    |--------------------------------------------------------------------------
    | Application URL
    |--------------------------------------------------------------------------
    |
    | This URL is used by the console to properly generate URLs when using
    | the Artisan command line tool. You should set this to the root of
    | your application so that it is used when running Artisan tasks.
    |
    */

    'url' => env('APP_URL', 'http://localhost'),

    'asset_url' => env('ASSET_URL', null),

    /*
    |--------------------------------------------------------------------------
    | Application Timezone
    |--------------------------------------------------------------------------
    |
    | Here you may specify the default timezone for your application, which
    | will be used by the PHP date and date-time functions. We have gone
    | ahead and set this to a sensible default for you out of the box.
    |
    */

    'timezone' => 'UTC',

    /*
    |--------------------------------------------------------------------------
    | Application Locale Configuration
    |--------------------------------------------------------------------------
    |
    | The application locale determines the default locale that will be used
    | by the translation service provider. You are free to set this value
    | to any of the locales which will be supported by the application.
    |
    */

    'locale' => 'en',

    /*
    |--------------------------------------------------------------------------
    | Application Fallback Locale
    |--------------------------------------------------------------------------
    |
    | The fallback locale determines the locale to use when the current one
    | is not available. You may change the value to correspond to any of
    | the language folders that are provided through your application.
    |
    */

    'fallback_locale' => 'en',

    /*
    |--------------------------------------------------------------------------
    | Faker Locale
    |--------------------------------------------------------------------------
    |
    | This locale will be used by the Faker PHP library when generating fake
    | data for your database seeds. For example, this will be used to get
    | localized telephone numbers, street address information and more.
    |
    */

    'faker_locale' => 'en_US',

    /*
    |--------------------------------------------------------------------------
    | Encryption Key
    |--------------------------------------------------------------------------
    |
    | This key is used by the Illuminate encrypter service and should be set
    | to a random, 32 character string, otherwise these encrypted strings
    | will not be safe. Please do this before deploying an application!
    |
    */

    'key' => env('APP_KEY'),

    'cipher' => 'AES-256-CBC',

    /*
    |--------------------------------------------------------------------------
    | Autoloaded Service Providers
    |--------------------------------------------------------------------------
    |
    | The service providers listed here will be automatically loaded on the
    | request to your application. Feel free to add your own services to
    | this array to grant expanded functionality to your applications.
    |
    */

    'providers' => [

        /*
         * Laravel Framework Service Providers...
         */
        Illuminate\Auth\AuthServiceProvider::class,
        Illuminate\Broadcasting\BroadcastServiceProvider::class,
        Illuminate\Bus\BusServiceProvider::class,
        Illuminate\Cache\CacheServiceProvider::class,
        Illuminate\Foundation\Providers\ConsoleSupportServiceProvider::class,
        Illuminate\Cookie\CookieServiceProvider::class,
        Illuminate\Database\DatabaseServiceProvider::class,
        Illuminate\Encryption\EncryptionServiceProvider::class,
        Illuminate\Filesystem\FilesystemServiceProvider::class,
        Illuminate\Foundation\Providers\FoundationServiceProvider::class,
        Illuminate\Hashing\HashServiceProvider::class,
        Illuminate\Mail\MailServiceProvider::class,
        Illuminate\Notifications\NotificationServiceProvider::class,
        Illuminate\Pagination\PaginationServiceProvider::class,
        Illuminate\Pipeline\PipelineServiceProvider::class,
        Illuminate\Queue\QueueServiceProvider::class,
        Illuminate\Redis\RedisServiceProvider::class,
        Illuminate\Auth\Passwords\PasswordResetServiceProvider::class,
        Illuminate\Session\SessionServiceProvider::class,
        Illuminate\Translation\TranslationServiceProvider::class,
        Illuminate\Validation\ValidationServiceProvider::class,
        Illuminate\View\ViewServiceProvider::class,

        /*
         * Package Service Providers...
         */

        SimpleSoftwareIO\QrCode\QrCodeServiceProvider::class,

        /*
         * Application Service Providers...
         */
        App\Providers\AppServiceProvider::class,
        App\Providers\AuthServiceProvider::class,
        // App\Providers\BroadcastServiceProvider::class,
        App\Providers\EventServiceProvider::class,
        App\Providers\RouteServiceProvider::class,

        Barryvdh\DomPDF\ServiceProvider::class,

    ],

    /*
    |--------------------------------------------------------------------------
    | Class Aliases
    |--------------------------------------------------------------------------
    |
    | This array of class aliases will be registered when this application
    | is started. However, feel free to register as many as you wish as
    | the aliases are "lazy" loaded so they don't hinder performance.
    |
    */

    'aliases' => [

        'App' => Illuminate\Support\Facades\App::class,
        'Arr' => Illuminate\Support\Arr::class,
        'Artisan' => Illuminate\Support\Facades\Artisan::class,
        'Auth' => Illuminate\Support\Facades\Auth::class,
        'Blade' => Illuminate\Support\Facades\Blade::class,
        'Broadcast' => Illuminate\Support\Facades\Broadcast::class,
        'Bus' => Illuminate\Support\Facades\Bus::class,
        'Cache' => Illuminate\Support\Facades\Cache::class,
        'Config' => Illuminate\Support\Facades\Config::class,
        'Cookie' => Illuminate\Support\Facades\Cookie::class,
        'Crypt' => Illuminate\Support\Facades\Crypt::class,
        'DB' => Illuminate\Support\Facades\DB::class,
        'Eloquent' => Illuminate\Database\Eloquent\Model::class,
        'Event' => Illuminate\Support\Facades\Event::class,
        'File' => Illuminate\Support\Facades\File::class,
        'Gate' => Illuminate\Support\Facades\Gate::class,
        'Hash' => Illuminate\Support\Facades\Hash::class,
        'Lang' => Illuminate\Support\Facades\Lang::class,
        'Log' => Illuminate\Support\Facades\Log::class,
        'Mail' => Illuminate\Support\Facades\Mail::class,
        'Notification' => Illuminate\Support\Facades\Notification::class,
        'Password' => Illuminate\Support\Facades\Password::class,
        'Queue' => Illuminate\Support\Facades\Queue::class,
        'Redirect' => Illuminate\Support\Facades\Redirect::class,
        'Redis' => Illuminate\Support\Facades\Redis::class,
        'Request' => Illuminate\Support\Facades\Request::class,
        'Response' => Illuminate\Support\Facades\Response::class,
        'Route' => Illuminate\Support\Facades\Route::class,
        'Schema' => Illuminate\Support\Facades\Schema::class,
        'Session' => Illuminate\Support\Facades\Session::class,
        'Storage' => Illuminate\Support\Facades\Storage::class,
        'Str' => Illuminate\Support\Str::class,
        'URL' => Illuminate\Support\Facades\URL::class,
        'Validator' => Illuminate\Support\Facades\Validator::class,
        'View' => Illuminate\Support\Facades\View::class,
        'QrCode' => SimpleSoftwareIO\QrCode\Facades\QrCode::class,

        'PDF' => Barryvdh\DomPDF\Facade::class,

    ],

];
