/*
Navicat MySQL Data Transfer

Source Server         : database
Source Server Version : 50505
Source Host           : 127.0.0.1:3306
Source Database       : tenancy_crm

Target Server Type    : MYSQL
Target Server Version : 50505
File Encoding         : 65001

Date: 2020-07-03 13:49:00
*/

SET FOREIGN_KEY_CHECKS=0;

-- ----------------------------
-- Table structure for companies
-- ----------------------------
DROP TABLE IF EXISTS `companies`;
CREATE TABLE `companies` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `website_id` int(10) unsigned NOT NULL,
  `tradename` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `address` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `telephone` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ----------------------------
-- Records of companies
-- ----------------------------

-- ----------------------------
-- Table structure for failed_jobs
-- ----------------------------
DROP TABLE IF EXISTS `failed_jobs`;
CREATE TABLE `failed_jobs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `connection` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `queue` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `exception` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ----------------------------
-- Records of failed_jobs
-- ----------------------------

-- ----------------------------
-- Table structure for hostnames
-- ----------------------------
DROP TABLE IF EXISTS `hostnames`;
CREATE TABLE `hostnames` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `fqdn` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `redirect_to` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `force_https` tinyint(1) NOT NULL DEFAULT 0,
  `under_maintenance_since` timestamp NULL DEFAULT NULL,
  `website_id` bigint(20) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `hostnames_fqdn_unique` (`fqdn`),
  KEY `hostnames_website_id_foreign` (`website_id`),
  CONSTRAINT `hostnames_website_id_foreign` FOREIGN KEY (`website_id`) REFERENCES `websites` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ----------------------------
-- Records of hostnames
-- ----------------------------

-- ----------------------------
-- Table structure for migrations
-- ----------------------------
DROP TABLE IF EXISTS `migrations`;
CREATE TABLE `migrations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `batch` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=303 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ----------------------------
-- Records of migrations
-- ----------------------------
INSERT INTO `migrations` VALUES ('291', '2014_10_12_000000_create_users_table', '1');
INSERT INTO `migrations` VALUES ('292', '2014_10_12_100000_create_password_resets_table', '1');
INSERT INTO `migrations` VALUES ('293', '2017_01_01_000003_tenancy_websites', '1');
INSERT INTO `migrations` VALUES ('294', '2017_01_01_000005_tenancy_hostnames', '1');
INSERT INTO `migrations` VALUES ('295', '2018_04_06_000001_tenancy_websites_needs_db_host', '1');
INSERT INTO `migrations` VALUES ('296', '2019_08_19_000000_create_failed_jobs_table', '1');
INSERT INTO `migrations` VALUES ('297', '2020_06_18_161647_create_system_modules', '1');
INSERT INTO `migrations` VALUES ('298', '2020_06_18_222717_create_companies', '1');
INSERT INTO `migrations` VALUES ('299', '2020_06_28_114647_create_system_typeproduct', '1');
INSERT INTO `migrations` VALUES ('300', '2020_07_01_150127_create_user_profiles', '1');
INSERT INTO `migrations` VALUES ('301', '2020_07_01_150328_create_system_moduleprofiles', '1');
INSERT INTO `migrations` VALUES ('302', '2020_07_01_150437_create_system_modulepermissions', '1');

-- ----------------------------
-- Table structure for password_resets
-- ----------------------------
DROP TABLE IF EXISTS `password_resets`;
CREATE TABLE `password_resets` (
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  KEY `password_resets_email_index` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ----------------------------
-- Records of password_resets
-- ----------------------------

-- ----------------------------
-- Table structure for system_modulepermissions
-- ----------------------------
DROP TABLE IF EXISTS `system_modulepermissions`;
CREATE TABLE `system_modulepermissions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `module_id` int(10) unsigned NOT NULL,
  `description` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ----------------------------
-- Records of system_modulepermissions
-- ----------------------------

-- ----------------------------
-- Table structure for system_moduleprofiles
-- ----------------------------
DROP TABLE IF EXISTS `system_moduleprofiles`;
CREATE TABLE `system_moduleprofiles` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `profile_id` int(10) unsigned NOT NULL,
  `module_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ----------------------------
-- Records of system_moduleprofiles
-- ----------------------------
INSERT INTO `system_moduleprofiles` VALUES ('1', '1', '1', null, null, null);
INSERT INTO `system_moduleprofiles` VALUES ('2', '1', '2', null, null, null);
INSERT INTO `system_moduleprofiles` VALUES ('3', '1', '7', null, null, null);
INSERT INTO `system_moduleprofiles` VALUES ('4', '1', '8', null, null, null);
INSERT INTO `system_moduleprofiles` VALUES ('5', '1', '9', null, null, null);
INSERT INTO `system_moduleprofiles` VALUES ('6', '1', '10', null, null, null);
INSERT INTO `system_moduleprofiles` VALUES ('7', '1', '11', null, null, null);
INSERT INTO `system_moduleprofiles` VALUES ('8', '1', '4', null, null, null);
INSERT INTO `system_moduleprofiles` VALUES ('9', '1', '13', null, null, null);
INSERT INTO `system_moduleprofiles` VALUES ('10', '1', '5', null, null, null);
INSERT INTO `system_moduleprofiles` VALUES ('11', '1', '14', null, null, null);
INSERT INTO `system_moduleprofiles` VALUES ('12', '2', '1', null, null, null);
INSERT INTO `system_moduleprofiles` VALUES ('13', '2', '4', null, null, null);
INSERT INTO `system_moduleprofiles` VALUES ('14', '2', '13', null, null, null);
INSERT INTO `system_moduleprofiles` VALUES ('15', '2', '5', null, null, null);

-- ----------------------------
-- Table structure for system_modules
-- ----------------------------
DROP TABLE IF EXISTS `system_modules`;
CREATE TABLE `system_modules` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `icon` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `position` int(11) DEFAULT NULL,
  `father_url` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `module` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ui_sref` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `father_id` int(11) DEFAULT NULL,
  `is_show` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ----------------------------
-- Records of system_modules
-- ----------------------------
INSERT INTO `system_modules` VALUES ('1', 'DASHBOARD', 'fas fa-chart-bar', '1', 'dashboard', 'dashboard', 'dashboard', null, '1', null, null, null);
INSERT INTO `system_modules` VALUES ('2', 'CATÁLOGO', 'fas fa-clipboard-list', '2', 'catalog', 'catalog', '#', null, '1', null, null, null);
INSERT INTO `system_modules` VALUES ('3', 'ALMACEN', 'fas fa-store', '3', 'warehouse', 'warehouse', '#', null, '1', null, null, null);
INSERT INTO `system_modules` VALUES ('4', 'VENTAS', 'fas fa-shopping-cart', '4', 'sales', 'sales', '#', null, '1', null, null, null);
INSERT INTO `system_modules` VALUES ('5', 'PEDIDOS', 'fas fa-shopping-basket', '4', 'contact', 'orders', 'order.orders', null, '1', null, null, null);
INSERT INTO `system_modules` VALUES ('6', 'GESTION USUARIOS', 'fas fa-laptop', '5', 'management', 'users', 'management.users', null, '1', null, null, null);
INSERT INTO `system_modules` VALUES ('7', 'Productos', null, '1', null, 'products', 'catalog.products', '2', '1', null, null, null);
INSERT INTO `system_modules` VALUES ('8', 'Marcas', null, '2', null, 'brands', 'catalog.brands', '2', '1', null, null, null);
INSERT INTO `system_modules` VALUES ('9', 'Categorías', null, '3', null, 'categories', 'catalog.categories', '2', '1', null, null, null);
INSERT INTO `system_modules` VALUES ('10', 'Líneas categorías', null, '4', null, 'lines', 'catalog.lines', '2', '1', null, null, null);
INSERT INTO `system_modules` VALUES ('11', 'Variantes', null, '5', null, 'variants', 'catalog.variants', '2', '1', null, null, null);
INSERT INTO `system_modules` VALUES ('12', 'Almacenes', null, '1', null, 'warehouses', 'warehouse.warehouses', '3', '1', null, null, null);
INSERT INTO `system_modules` VALUES ('13', 'Clientes', null, '1', null, 'clients', 'sales.clients', '4', '1', null, null, null);
INSERT INTO `system_modules` VALUES ('14', 'ENCUESTAS', 'fas fa-file-alt', '6', 'dashboard', 'survey', 'survey.poll', null, '1', null, null, null);

-- ----------------------------
-- Table structure for system_typeproduct
-- ----------------------------
DROP TABLE IF EXISTS `system_typeproduct`;
CREATE TABLE `system_typeproduct` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sunat_id` char(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ----------------------------
-- Records of system_typeproduct
-- ----------------------------
INSERT INTO `system_typeproduct` VALUES ('1', 'BIENES', 'bienes', '2001', null, null, null);
INSERT INTO `system_typeproduct` VALUES ('2', 'SERVICIOS', 'servicios', '2002', null, null, null);
INSERT INTO `system_typeproduct` VALUES ('3', 'CONTRATOS', 'contratos', '2003', null, null, '2020-08-21 13:48:01');

-- ----------------------------
-- Table structure for users
-- ----------------------------
DROP TABLE IF EXISTS `users`;
CREATE TABLE `users` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email_verified_at` timestamp NULL DEFAULT NULL,
  `password` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `remember_token` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `users_email_unique` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ----------------------------
-- Records of users
-- ----------------------------
INSERT INTO `users` VALUES ('1', 'SUPER ADMIN', 'admin@gmail.com', null, '$2y$10$5BmUWPYzlGWMUJs3iVlf0eVQb2ywLHA84Xk5HtDBC3QBY5Fsn4b/S', null, null, null);

-- ----------------------------
-- Table structure for user_profiles
-- ----------------------------
DROP TABLE IF EXISTS `user_profiles`;
CREATE TABLE `user_profiles` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ----------------------------
-- Records of user_profiles
-- ----------------------------
INSERT INTO `user_profiles` VALUES ('1', 'ADMINISTRADOR', null, null, null);
INSERT INTO `user_profiles` VALUES ('2', 'VENDEDOR', null, null, null);
INSERT INTO `user_profiles` VALUES ('3', 'CAJERO', null, null, null);
INSERT INTO `user_profiles` VALUES ('4', 'ALMACENERO', null, null, null);

-- ----------------------------
-- Table structure for websites
-- ----------------------------
DROP TABLE IF EXISTS `websites`;
CREATE TABLE `websites` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `uuid` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `managed_by_database_connection` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'References the database connection key in your database.php',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ----------------------------
-- Records of websites
-- ----------------------------
