<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSystemModules extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('system_modules', function (Blueprint $table) {
            $table->increments('id');
            $table->string('name', 60);
            $table->string('icon', 60)->nullable();
            $table->integer('position')->nullable();
            $table->string('father_url', 60)->nullable();
            $table->string('module', 60)->nullable();
            $table->string('ui_sref', 100)->nullable();
            $table->integer('father_id')->nullable();
            $table->boolean('is_show')->default(true);
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('system_modules');
    }
}
