<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCompanies extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('companies', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('website_id')->unsigned();
            $table->integer('category_id')->unsigned()->nullable();
            $table->integer('plan_id')->unsigned()->nullable();
            $table->string('ruc');
            $table->string('social_reason');
            $table->string('tradename')->nullable();
            $table->string('address')->nullable();
            $table->string('ubigeo')->nullable();
            $table->string('email')->nullable();
            $table->string('cellphone',20)->nullable();
            $table->string('telephone',20)->nullable();
            $table->string('offers_description')->nullable()->comment("descripcion de lo que ofrece la empresa");
            $table->string('activity_description')->nullable()->comment("descripcion de la actividad principal de la empresa");
            $table->string('api_facturador')->nullable();
            $table->string('api_token')->nullable();
            $table->string('url_image')->nullable();
            $table->boolean('send_billing')->default(true)->nullable()->comment("FALSE: deshabilitar el envio de comprobantes electronicos");
            $table->integer('typebilling_id')->unsigned()->default(1)->comment("1: factura exonerada, 2: factura gravada");
            $table->boolean('control_permissions')->default(false)->comment("TRUE: la mepresa ya puede funcionar con los permisos de usuario");
            $table->timestamps();
            $table->softDeletes();
        });
    }


    public function down()
    {
        Schema::dropIfExists('companies');
    }
}
