<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSystemModulepermissions extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('system_modulepermissions', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('module_id')->unsigned();
            $table->string('description', 150);
            $table->text('observation')->nullable();
            $table->string('code', 100);
            $table->string('action', 50)->nullable();
            $table->integer('position')->nullable();
            $table->boolean('is_show')->default(true);
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('system_modulepermissions');
    }
}
