<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSaleClients extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('sale_clients', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('typedocument_id')->unsigned();
            $table->char('type_client', 2)->nullable();
            $table->string('fullname');
            $table->string('document', 20)->nullable();
            $table->string('tradename')->nullable();
            $table->string('address')->nullable();
            $table->string('email')->nullable();
            $table->string('telephone',20)->nullable();
            $table->string('cellphone',20)->nullable();
            $table->date('date_birthday')->nullable();
            $table->char('sex', 1)->nullable();
            $table->char('status', 2)->nullable()->comment("soltero o casado o viudo");
            $table->text('url_image')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('sale_clients');
    }
}
