<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSaleOrders extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('sale_orders', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('user_id')->unsigned();
            $table->integer('branchoffice_id')->unsigned();
            $table->integer('client_id')->unsigned()->nullable();
            $table->integer('delivery_id')->unsigned()->nullable();
            $table->integer('employe_id')->unsigned()->nullable();
            $table->integer('sale_id')->nullable();
            $table->string('nro_voucher', 50)->nullable();
            $table->string('code', 20)->nullable();
            $table->string('correlative', 20)->nullable();
            $table->datetime('date_order');
            $table->datetime('date_command')->nullable();
            $table->char('shift',1)->nullable()->comment("1 = mañana, 2 = tarde");
            $table->boolean('is_igv')->default(false);
            $table->decimal('igv',18,2)->nullable();
            $table->decimal('total',18,2)->nullable();
            $table->decimal('subtotal',18,2)->nullable();
            $table->string('text_amount')->nullable();
            $table->string('observation')->nullable();
            $table->string('reference')->nullable();
            $table->string('number_table')->nullable();
            $table->boolean('is_delivered')->default(false);
            $table->boolean('status_command')->default(false)->comment("TRUE: cuando la comanda ha sido cerrada");
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('sale_orders');
    }
}
