<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCatalogProducts extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('catalog_products', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->char('type_product', 1);
            $table->integer('typeprice_id')->unsigned();
            $table->integer('line_id')->unsigned()->nullable();
            $table->integer('brand_id')->unsigned()->nullable();
            $table->string('code');
            $table->string('code_reference')->nullable();
            $table->string('description');
            $table->text('comment')->nullable();
            $table->string('url_image')->nullable();
            $table->boolean('is_show')->default(true);
            $table->boolean('is_favorite')->default(false);
            $table->boolean('is_control_stock')->default(false);
            $table->boolean('is_limit_stock')->default(false);
            $table->decimal('limit_stock',18,2)->nullable();
            $table->boolean('is_control_expiration')->default(false);
            $table->boolean('is_limit_expiration')->default(false);
            $table->decimal('limit_expiration',18,0)->nullable();
            $table->boolean('is_grouped')->default(false)->comment("TRUE: producto agrupado");
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('catalog_products');
    }
}
