<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateConfigUnitsofmeasure extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('config_unitsofmeasure', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('description');
            $table->string('plural')->nullable();
            $table->string('prefix')->nullable();
            $table->char('type_equivalence',2)->comment("D: decimal  - I: integer");
            $table->decimal('equivalence',18,2)->nullable();
            $table->char('parent_unit_id',3)->nullable();
            $table->char('code');
            $table->boolean('is_principal')->default(false);
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('config_unitsofmeasure');
    }
}
