<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateWarehouseWarehouses extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('warehouse_warehouses', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('branchoffice_id')->unsigned();
            $table->string('description');
            $table->string('comment')->nullable();
            $table->boolean('is_principal')->default(false);
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('warehouse_warehouses');
    }
}

