<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCatalogProductvariants extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('catalog_productvariants', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('product_id')->unsigned();
            $table->integer('typevariant_id')->unsigned();
            $table->integer('unit_id')->unsigned()->nullable();
            $table->decimal('stock',18,2)->nullable();
            $table->decimal('price_sale',18,2)->nullable();
            $table->decimal('price_purchase',18,2)->nullable();
            $table->boolean('is_active')->default(false);
            $table->decimal('equivalence',18,4)->nullable();
            $table->boolean('is_principal')->default(false);
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('catalog_productvariants');
    }
}
