<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCatalogProductequivalences extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('catalog_productequivalences', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('product_id')->unsigned();
            $table->integer('unit_id')->unsigned();
            $table->decimal('equivalence',18,2);
            $table->decimal('price_purchase',18,2)->nullable();
            $table->decimal('price_min',18,2)->nullable();
            $table->decimal('price_sale',18,2);
            $table->decimal('price_credit',18,2)->nullable();
            $table->decimal('price_wholesaler',18,2)->nullable();
            $table->boolean('is_active')->default(false);
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('catalog_productequivalences');
    }
}
