<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateWarehouseMovements extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('warehouse_movements', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('user_id')->unsigned();
            $table->integer('warehouse_id')->unsigned();
            $table->integer('warehouseconcept_id')->unsigned();
            $table->integer('branchoffice_id')->unsigned()->nullable();
            $table->date('date_movement');
            $table->string('nro_voucher')->nullable();
            $table->string('correlative')->nullable();
            $table->string('reason')->nullable();
            $table->char('type_movement',1)->comment('E: entrada , S: salida');
            $table->boolean('is_newproduct')->default(false);
            $table->string('url_file')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('warehouse_movements');
    }
}
