<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateWarehouseDetailmovements extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('warehouse_detailmovements', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('warehousemovement_id')->unsigned();
            $table->integer('warehouse_id')->unsigned();
            $table->integer('productbatch_id')->unsigned()->nullable();
            $table->integer('product_id')->unsigned();
            $table->integer('unitmeasure_id')->unsigned();
            $table->decimal('quantity',18,2)->default(0);
            $table->decimal('price',18,2)->default(0);
            $table->decimal('equivalence',18,2)->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('warehouse_detailmovements');
    }
}
