<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePurchaseProviders extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('purchase_providers', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('fullname');
            $table->string('document', 20)->nullable();
            $table->string('tradename')->nullable();
            $table->string('address')->nullable();
            $table->string('email')->nullable();
            $table->string('telephone',20)->nullable();
            $table->string('cellphone',20)->nullable();
            $table->char('status', 2)->nullable();
            $table->text('url_image')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('purchase_providers');
    }
}
