<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePurchasePurchases extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('purchase_purchases', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('user_id')->unsigned();
            $table->integer('provider_id')->unsigned();
            $table->integer('branchoffice_id')->unsigned();
            $table->integer('warehouse_id')->unsigned();
            $table->integer('typetransaction_id')->unsigned();
            $table->integer('currency_id')->unsigned();
            $table->integer('typevoucher_id')->unsigned();
            $table->integer('paymentmethod_id')->unsigned()->nullable();
            $table->integer('accountbank_id')->nullable()->nullable();
            $table->string('nro_voucher', 50)->nullable();
            $table->string('code', 20)->nullable();
            $table->string('correlative', 20)->nullable();
            $table->string('nro_guidereference', 50)->nullable();
            $table->date('date_purchase');
            $table->boolean('is_igv')->default(false);
            $table->decimal('exchange_currency', 18,2);
            $table->decimal('igv',18,2)->nullable();
            $table->decimal('subtotal',18,2)->nullable();
            $table->decimal('total',18,2)->nullable();
            $table->string('observation')->nullable();
            $table->string('url_file')->nullable();
            $table->char('status_paid', 1)->default('C')->comment('C: Cancelado : y P: pendiente');
            $table->boolean('affect_moneybox')->default(false);
            $table->string('reference_operation')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('purchase_purchases');
    }
}
