<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePurchaseDetailpurchases extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('purchase_detailpurchases', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('purchase_id')->unsigned();
            $table->integer('warehouse_id')->unsigned();
            $table->integer('product_id')->unsigned();
            $table->integer('productbatch_id')->unsigned()->nullable();
            $table->integer('unitmeasure_id')->unsigned();
            $table->decimal('quantity',18,2)->default(0);
            $table->decimal('price',18,2)->default(0);
            $table->decimal('discount',18,2)->default(0);
            $table->decimal('igv',18,2)->default(0);
            $table->decimal('equivalence',18,2)->nullable();
            $table->boolean('is_igv')->default(false)->nullable()->comment("en el caso de que el item incluya el igv");
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('purchase_detailpurchases');
    }
}
