<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateConfigCurrency extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('config_currency', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('description', 50);
            $table->string('plural', 50);
            $table->string('currency', 50);
            $table->char('symbol', 10);
            $table->decimal('exchange_rate',18,2)->default(0);
            $table->boolean('is_principal')->default(false);
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('config_currency');
    }
}
