<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateConfigTax extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('config_tax', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->char('sunat_id', 10)->nullable();
            $table->string('description', 20);
            $table->string('summary')->nullable();
            $table->decimal('percentage');
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('config_tax');
    }
}
