<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateMoneyBox extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('money_box', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('branchbox_id')->unsigned();
            $table->integer('user_id')->unsigned();
            $table->dateTime('date_opening');
            $table->decimal('amount_opening',18,2)->default(0);
            $table->decimal('balance',18,2);
            $table->dateTime('date_closing')->nullable();
            $table->decimal('amount_closing',18,2)->nullable();
            $table->boolean('status_closed')->default(false);
            $table->char('user_closebox')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('money_box');
    }
}
