<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateMoneyMovements extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('money_movements', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('user_id')->unsigned();
            $table->integer('branchoffice_id')->unsigned();
            $table->integer('moneybox_id')->unsigned();
            $table->integer('concept_id')->unsigned();
            $table->integer('paymentmethod_id')->unsigned();
            $table->integer('currency_id')->unsigned();
            $table->integer('voucher_id')->nullable();
            $table->integer('client_id')->nullable();
            $table->integer('provider_id')->nullable();
            $table->integer('employee_id')->nullable();
            $table->integer('accountbank_id')->nullable();
            $table->dateTime('date_movement');
            $table->decimal('amount',18,2);
            $table->string('text_amount')->nullable();
            $table->string('gloss')->nullable();
            $table->string('reference_operation')->nullable();
            $table->string('nro_voucher')->nullable();
            $table->string('serie')->nullable();
            $table->string('correlative')->nullable();
            $table->string('billing_external_id')->nullable();
            $table->text('billing_hash')->nullable();
            $table->text('billing_response')->nullable();
            $table->string('motive_cancelled')->nullable();
            $table->text('billing_cancelled')->nullable();
            $table->dateTime('date_repayment')->nullable();
            $table->char('repaymentmovement_id')->nullable();
            $table->char('dischargedocument_id')->nullable();
            $table->boolean('is_voucher_external')->default(false);
            $table->integer('voucher_external')->nullable();
            $table->string('nro_voucher_external', 50)->nullable();
            $table->boolean('is_note_document')->default(false);
            $table->char('notedocument_id')->nullable();
            //FOR HOTEL BOOKINGS ACTIONS
            $table->integer('hotelbooking_id')->nullable();            
            
            //FOR TOURISM =================
            $table->integer('booking_id')->nullable();

            $table->integer('commision_id')->nullable();
            $table->string('observation')->nullable();
            $table->boolean('is_visible')->default(true);

            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('money_movements');
    }
}
