<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSaleSales extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('sale_sales', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('user_id')->unsigned();
            $table->integer('branchoffice_id')->unsigned();
            $table->integer('typetransaction_id')->unsigned();
            $table->integer('client_id')->unsigned()->nullable();
            $table->integer('employe_id')->unsigned()->nullable();
            $table->integer('delivery_id')->unsigned()->nullable();
            $table->integer('origin_id')->unsigned()->nullable();
            $table->integer('channel_id')->unsigned()->nullable();
            $table->integer('bookinghotel_id')->unsigned()->nullable()->comment("Consumos asociados a reservas de hotel");
            $table->string('code', 20)->nullable();
            $table->string('correlative', 20)->nullable();
            $table->dateTime('date_sale');
            $table->boolean('is_igv')->default(false);
            $table->decimal('igv',18,2)->nullable();
            $table->decimal('subtotal',18,2)->nullable();
            $table->decimal('discount',18,2)->nullable();
            $table->decimal('tax_icbper',18,2)->default(0);
            $table->decimal('total',18,2)->nullable();
            $table->boolean('is_grouped')->default(false);
            $table->string('description_grouped')->nullable();
            $table->string('observation')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('sale_sales');
    }
}
