<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSalePaid extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('sale_paid', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('sale_id')->unsigned()->nullable();
            $table->integer('booking_id')->unsigned()->nullable();
            $table->decimal('total_amount',18,2);
            $table->decimal('total_paid',18,2);
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('sale_paid');
    }
}
