<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSaleAmortizations extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('sale_amortizations', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('salepaid_id')->unsigned();
            $table->integer('moneymovement_id')->unsigned();
            $table->string('description')->nullable();
            $table->decimal('total_amount',18,2);
            $table->dateTime('date_repayment')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('sale_amortizations');
    }
}
