<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateBranchConfig extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('branch_config', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('branchoffice_id')->unsigned();
            $table->string('theme');
            $table->string('print_boleta');
            $table->string('print_factura');
            $table->boolean('is_search_barcode')->default(false);
            $table->boolean('is_default_client')->default(false);
            $table->string('typevoucher_default',2)->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('branch_config');
    }
}
