<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSaleDetailschedule extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('sale_detailschedule', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('schedule_id')->unsigned();
            $table->integer('saleamortization_id')->unsigned()->nullable();
            $table->integer('number_quota');
            $table->date('date_assigned');
            $table->decimal('amount_assigned',18,2);
            $table->date('date_paid')->nullable();
            $table->decimal('amount_paid',18,2)->default(0);
            $table->boolean('is_paid')->default(false);
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('sale_detailschedule');
    }
}
