<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCompanyEmployees extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('company_employees', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('companyjob_id')->unsigned()->nullable();
            $table->integer('typedocument_id')->unsigned();
            $table->string('code')->nullable();
            $table->string('fullname');
            $table->string('document', 20)->nullable();
            $table->string('address')->nullable();
            $table->string('email')->nullable();
            $table->string('telephone',20)->nullable();
            $table->string('cellphone',20)->nullable();
            $table->date('date_birthday')->nullable();
            $table->char('sex', 1)->nullable();
            $table->char('status', 2)->nullable()->comment("soltero o casado o viudo");
            $table->text('url_image')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('company_employees');
    }
}
