<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateFinanceAccountbanks extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('finance_accountbanks', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('branchoffice_id')->unsigned();
            $table->integer('bank_id')->unsigned();
            $table->integer('typeaccount_id')->unsigned();
            $table->integer('currency_id')->unsigned();
            $table->string('name');
            $table->string('number_account')->nullable();
            $table->string('cci_account')->nullable();
            $table->decimal('balance',18,2)->nullable();
            $table->string('headline')->nullable()->comment("titular de la cuenta");
            $table->string('description')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('finance_accountbanks');
    }
}
