<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSaleProformas extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('sale_proformas', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('user_id')->unsigned();
            $table->integer('branchoffice_id')->unsigned();
            $table->integer('voucher_id')->nullable();
            $table->integer('client_id')->nullable();
            $table->integer('provider_id')->nullable();
            $table->integer('employee_id')->nullable();
            $table->integer('sale_id')->nullable();
            $table->integer('accountbank_id')->nullable();
            $table->string('nro_voucher')->nullable();
            $table->string('serie')->nullable();
            $table->string('correlative')->nullable();
            $table->date('date_issue');
            $table->date('date_expiration')->nullable();
            $table->boolean('is_igv')->default(false);
            $table->decimal('igv',18,2)->nullable();
            $table->decimal('subtotal',18,2)->nullable();
            $table->decimal('total',18,2)->nullable();
            $table->string('text_amount')->nullable();
            $table->string('observation')->nullable();
            $table->string('url_file')->nullable();
            $table->string('address')->nullable();
            $table->string('email')->nullable();
            $table->string('cellphone',20)->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('sale_proformas');
    }
}
