<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSaleDetailproformas extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('sale_detailproformas', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('proforma_id')->unsigned();
            $table->integer('product_id')->unsigned();
            $table->integer('unitmeasure_id')->unsigned();
            $table->decimal('quantity',18,2)->default(0);
            $table->decimal('price',18,2)->default(0);
            $table->decimal('discount',18,2)->default(0);
            $table->decimal('igv',18,2)->default(0);
            $table->decimal('equivalence',18,2)->nullable();
            $table->string('detail')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('sale_detailproformas');
    }
}
