<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCatalogProductconfig extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('catalog_productconfig', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('branchoffice_id')->unsigned();
            $table->integer('product_id')->unsigned();
            $table->boolean('is_show')->default(true);
            $table->boolean('is_favorite')->default(false);
            $table->boolean('is_control_stock')->default(false);
            $table->boolean('is_limit_stock')->default(false);
            $table->decimal('limit_stock',18,2)->nullable();
            $table->boolean('is_control_expiration')->default(false);
            $table->boolean('is_limit_expiration')->default(false);
            $table->decimal('limit_expiration',18,0)->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('catalog_productconfig');
    }
}
