<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePurchaseOrders extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('purchase_orders', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('user_id')->unsigned();
            $table->integer('branchoffice_id')->unsigned();
            $table->integer('provider_id')->unsigned();
            $table->integer('purchase_id')->nullable();
            $table->string('nro_voucher', 50)->nullable();
            $table->string('code', 20)->nullable();
            $table->string('correlative', 20)->nullable();
            $table->date('date_order');
            $table->boolean('is_igv')->default(false);
            $table->decimal('igv',18,2)->nullable();
            $table->decimal('subtotal',18,2)->nullable();
            $table->decimal('total',18,2)->nullable();
            $table->string('text_amount')->nullable();
            $table->string('delivery_terms')->nullable();
            $table->string('observation')->nullable();
            $table->boolean('is_delivered')->default(false);
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('purchase_orders');
    }
}
