<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateWarehouseTransfers extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('warehouse_transfers', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('user_id')->unsigned();
            $table->integer('branchoffice_id')->unsigned()->nullable();
            $table->integer('movemententry_id')->unsigned();
            $table->integer('movementouput_id')->unsigned();
            $table->integer('warehouseorigin_id')->unsigned();
            $table->integer('warehousdestiny_id')->unsigned();
            $table->date('date_transfer');
            $table->integer('warehouseconcept_id')->unsigned();
            $table->string('nro_voucher')->nullable();
            $table->string('correlative')->nullable();
            $table->string('reason')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('warehouse_transfers');
    }
}
