<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateBillingNotedocuments extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('billing_notedocuments', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('user_id')->unsigned();
            $table->integer('branchoffice_id')->unsigned();
            $table->integer('paymentmethod_id')->unsigned();
            $table->integer('currency_id')->unsigned();
            $table->integer('movement_id')->unsigned();
            $table->integer('voucher_id')->unsigned();
            $table->integer('billingcode_id')->unsigned();
            $table->integer('client_id')->nullable();
            $table->dateTime('date_document');
            $table->string('nro_voucher')->nullable();
            $table->string('serie')->nullable();
            $table->string('correlative')->nullable();
            $table->string('billing_external_id')->nullable();
            $table->text('billing_hash')->nullable();
            $table->text('billing_response')->nullable();
            $table->decimal('igv',18,2)->nullable();
            $table->decimal('subtotal',18,2)->nullable();
            $table->decimal('discount',18,2)->nullable();
            $table->decimal('tax_icbper',18,2)->default(0);
            $table->decimal('total',18,2)->nullable();
            $table->string('text_amount')->nullable();
            $table->decimal('exchange_currency', 18,2);
            $table->string('motive')->nullable();
            $table->string('observation')->nullable();
            $table->boolean('affect_moneybox')->default(false);
            $table->boolean('return_warehouse')->default(false);
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('billing_notedocuments');
    }
}
