<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateBillingNotedocumentsdetail extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('billing_notedocumentsdetail', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('notedocument_id')->unsigned();
            $table->integer('warehouse_id')->unsigned()->nullable();
            $table->integer('product_id')->unsigned();
            $table->integer('unitmeasure_id')->unsigned();
            $table->decimal('quantity',18,2)->default(0);
            $table->decimal('price',18,2)->default(0);
            $table->decimal('discount',18,2)->default(0);
            $table->decimal('igv',18,2)->default(0)->nullable();
            $table->integer('productvariant_id')->unsigned()->nullable();
            $table->integer('productequivalence_id')->unsigned()->nullable();
            $table->decimal('equivalence_val',18,4)->nullable();
            $table->decimal('price_general',18,2);
            $table->string('description')->nullable()->comment("descripcion por item");
            $table->boolean('is_igv')->default(false)->nullable()->comment("en el caso de que el item incluya el igv");
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('billing_notedocumentsdetail');
    }
}
