<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateHotelBedrooms extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('hotel_bedrooms', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('roomtype_id')->unsigned()->nullable();
            $table->string('code_number');
            $table->string('description')->nullable();
            $table->char('status',1)->default('A')->comment("A: available, M: maintenance O: occupied");
            $table->char('floor',2)->nullable();
            $table->string('observations')->nullable();
            $table->boolean('is_show')->default(true);
            $table->boolean('is_dirty')->default(false);
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('hotel_bedrooms');
    }
}
