<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateHotelBookings extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('hotel_bookings', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('user_id')->unsigned();
            $table->integer('bookingorigin_id')->unsigned()->nullable()->comment("origen de la reserva");
            $table->integer('arrivalplace_id')->unsigned()->nullable()->comment("Lugar donde llegara el pasajero");
            $table->integer('collaborator_id')->unsigned()->nullable();
            $table->string('code', 20)->nullable();
            $table->string('correlative', 20)->nullable();
            $table->integer('nro_pax')->nullable();
            $table->string('observations')->nullable();
            $table->string('arrival_place')->nullable();
            $table->string('contact_emergency')->nullable();
            $table->string('telephone_emergency')->nullable();
            $table->boolean('is_checkin')->default(false)->comment("TRUE: cuando el pasajero ya llegó. Importante para realizar sus tours");
            $table->boolean('is_checkout')->default(false)->comment("TRUE: cuando el programa haya concluido,  opcional por el momento");
            $table->boolean('is_postponed')->default(false)->comment("TRUE: en caso la reserva sea pospuesta para otra fecha");
            $table->boolean('is_igv')->default(false);
            $table->decimal('igv',18,2)->nullable();
            $table->decimal('discount',18,2)->default(0);
            $table->decimal('total',18,2)->default(0);
            $table->decimal('total_paid',18,2)->default(0)->comment("total PAGADO de la reserva");
            $table->decimal('total_billing',18,2)->default(0)->comment("total FACTURADO de la reserva");
            $table->string('text_amount')->nullable();
            $table->integer('user_id_postponed')->nullable();
            $table->string('postponed_description')->nullable();
            $table->boolean('is_credit')->default(false)->comment("TRUE: cuando la reserva es pasada a credito");
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('hotel_bookings');
    }
}
