<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateHotelDetailbedrooms extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('hotel_detailbedrooms', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('booking_id')->unsigned()->nullable();
            $table->integer('bedroom_id')->unsigned()->nullable();
            $table->integer('roomtype_id')->unsigned()->nullable();
            $table->integer('ratebedroom_id')->unsigned()->nullable();
            $table->datetime('date_checkin')->nullable();
            $table->datetime('date_checkout')->nullable();
            $table->integer('number_nights')->nullable();
            $table->integer('nro_pax')->nullable();
            $table->decimal('rate',18,2)->nullable();
            $table->string('last_bedroom', 20)->nullable();
            $table->integer('number_adults')->nullable();
            $table->integer('number_kids')->nullable();
            $table->integer('number_towells')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('hotel_detailbedrooms');
    }
}
