<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateBranchCollaborators extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('branch_collaborators', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('typecollaborator_id')->unsigned()->nullable()->comment("tipo colaborador");
            $table->string('document', 20)->nullable();
            $table->string('fullname')->nullable();
            $table->string('tradename')->nullable();
            $table->string('address')->nullable();
            $table->string('email')->nullable();
            $table->string('telephone',20)->nullable();
            $table->string('cellphone',20)->nullable();
            $table->string('category',1)->nullable()->comment("for category hotel");
            $table->char('status', 2)->nullable();
            $table->text('url_image')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('branch_collaborators');
    }
}
