<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateBillingReferralguide extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('billing_referralguide', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('user_id')->unsigned();
            $table->integer('branchoffice_id')->unsigned();
            $table->integer('modetransport_id')->unsigned();
            $table->integer('transferreason_id')->unsigned();
            $table->integer('client_id')->unsigned();
            $table->integer('voucher_id')->unsigned();
            $table->string('nro_voucher')->nullable();
            $table->string('serie')->nullable();
            $table->dateTime('date_issue');
            $table->dateTime('date_transfer');
            $table->integer('unitmeasure_id')->unsigned();
            $table->decimal('overall_weight',18,4)->default(0);
            $table->decimal('number_packages',18,2)->default(0);
            $table->string('description_motive')->nullable();
            $table->string('observations')->nullable();
            $table->string('purchase_order')->nullable();            
            $table->text('billing_response')->nullable()->comment("respuesta facturador");
            $table->integer('voucher_reference_id')->nullable()->comment("referencia del comprobante del cual se esta emitiendo");
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('billing_referralguide');
    }
}
