<?php

use Illuminate\Database\Seeder;

class SystemModulePermissionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */

    public $key;
    public $arr;

    public function run()
    {

        \DB::table('system_modulepermissions')->insert([
            'module_id' => $this->array_value_recursive('venta'),
            'description' => 'Crear venta',
            'code' => 'sales_sale_create',
            'action' => 'hidden',
            'is_show' => true,
            'position' => 1,
        ]);

        \DB::table('system_modulepermissions')->insert([
            'module_id' => $this->array_value_recursive('venta'),
            'description' => 'Exportar venta',
            'code' => 'sales_sale_export',
            'action' => 'disabled',
            'is_show' => true,
            'position' => 2,
        ]);

        \DB::table('system_modulepermissions')->insert([
            'module_id' => $this->array_value_recursive('venta'),
            'description' => 'Editar precio en venta',
            'code' => 'sales_sale_editprice',
            'action' => 'disabled',
            'is_show' => true,
            'position' => 3,
        ]);

        \DB::table('system_modulepermissions')->insert([
            'module_id' => $this->array_value_recursive('venta'),
            'description' => 'Cambiar tipo de precio en venta',
            'code' => 'sales_sale_changetypeprice',
            'action' => 'disabled',
            'is_show' => true,
            'position' => 3,
        ]);

    }

    function array_value_recursive($key){

        $modules = array(
            'dashboard' => 1,
            'empresa' => 2,
            'catalogo' => 3,
            array(
                'servicios' => 17,
            ),
            'almacen' => 4,
            'compras' => 5,
            'ventas' => 6,
            array(
                'venta' => 36,
            ),
            'facturacion' => 7,
            'caja' => 8,
            'ajustes' => 9,
            'seguridad' => 10,
            'reportes' => 11,
            'finanzas' => 12,
            'restaurante' => 13,
        );

        $val = array();
        array_walk_recursive($modules, function($v, $k) use($key, &$val){
            if($k == $key) array_push($val, $v);
        });
        return count($val) > 1 ? $val : array_pop($val);
    }
}
