<?php

use Illuminate\Database\Seeder;

class SystemModuleSeeder extends Seeder
{

    public function run()
    {
        // 1 DASHBOARD
        \DB::table('system_modules')->insert([
            'name' => 'DASHBOARD',
            'position' => 1,
            'father_url' => 'dashboard',
            'module' => 'dashboard',
            'ui_sref' => 'dashboard',
            'icon' => 'fas fa-chart-bar',
        ]);

        // 2 MI EMPRESA
        \DB::table('system_modules')->insert([
            'name' => 'MI EMPRESA',
            'position' => 2,
            'father_url' => 'company',
            'module' => 'company',
            'ui_sref' => '#',
            'icon' => 'fas fa-home',
        ]);


        // 3 CATALOGO
        \DB::table('system_modules')->insert([
            'name' => 'CATÁLOGO',
            'position' => 2,
            'father_url' => 'catalog',
            'module' => 'catalog',
            'ui_sref' => '#',
            'icon' => 'fas fa-clipboard-list',
        ]);

        // 4 ALMACEN
        \DB::table('system_modules')->insert([
            'name' => 'ALMACEN',
            'position' => 3,
            'father_url' => 'warehouse',
            'module' => 'warehouse',
            'ui_sref' => '#',
            'icon' => 'fas fa-store',
        ]);

        // 5 COMPRAS

        \DB::table('system_modules')->insert([
            'name' => 'COMPRAS',
            'position' => 4,
            'father_url' => 'purchase',
            'module' => 'purchase',
            'ui_sref' => '#',
            'icon' => 'fas fa-shopping-basket',
        ]);


        // 6 VENTAS

        \DB::table('system_modules')->insert([
            'name' => 'VENTAS',
            'position' => 5,
            'father_url' => 'sales',
            'module' => 'sales',
            'ui_sref' => '#',
            'icon' => 'fas fa-shopping-cart',
        ]);

        // 7 FACTURACIÓN

        \DB::table('system_modules')->insert([
            'name' => 'FACTURACIÓN',
            'position' => 6,
            'father_url' => 'billing',
            'module' => 'billing',
            'ui_sref' => '#',
            'icon' => 'fas fa-file-archive',
        ]);

        // 8 CAJA

        \DB::table('system_modules')->insert([
            'name' => 'CAJA',
            'position' => 7,
            'father_url' => 'money',
            'module' => 'money',
            'ui_sref' => '#',
            'icon' => 'fas fa-toolbox',
        ]);

        // 9 CAJA

        \DB::table('system_modules')->insert([
            'name' => 'AJUSTES',
            'position' => 10,
            'father_url' => 'setting',
            'module' => 'setting',
            'ui_sref' => '#',
            'icon' => 'fas fa-cogs',
        ]);

        // 10 SEGURIDAD

        \DB::table('system_modules')->insert([
            'name' => 'SEGURIDAD',
            'position' => 9,
            'father_url' => 'security',
            'module' => 'security',
            'ui_sref' => '#',
            'icon' => 'fas fa-lock',
            'is_show'=> true
        ]);


        \DB::table('system_modules')->insert([
            'name' => 'REPORTES',
            'position' => 8,
            'father_url' => 'report',
            'module' => 'report',
            'ui_sref' => '#',
            'icon' => 'fas fa-chalkboard-teacher',
            'is_show'=> true
        ]);

        \DB::table('system_modules')->insert([
            'name' => 'FINANZAS',
            'position' => 5,
            'father_url' => 'finance',
            'module' => 'finance',
            'ui_sref' => '#',
            'icon' => 'fas fa-money-bill-wave',
            'is_show'=> true
        ]);

//        \DB::table('system_modules')->insert([
//            'name' => 'GESTION USUARIOS',
//            'position' => 5,
//            'father_url' => 'management',
//            'module' => 'users',
//            'ui_sref' => 'management.users',
//            'icon' => 'fas fa-laptop',
//            'is_show'=>false
//        ]);

        \DB::table('system_modules')->insert([
            'name' => 'RESTAURANTE',
            'position' => 5,
            'father_url' => 'restaurant',
            'module' => 'restaurant',
            'ui_sref' => '#',
            'icon' => 'fas fa-solar-panel',
        ]);

        \DB::table('system_modules')->insert([
            'name' => 'HOTELERIA',
            'position' => 5,
            'father_url' => 'hotel',
            'module' => 'hotel',
            'ui_sref' => '#',
            'icon' => 'fas fa-hotel ',
        ]);


        $modules = array(
            'dashboard' => 1,
            'empresa' => 2,
            'catalogo' => 3,
            'almacen' => 4,
            'compras' => 5,
            'ventas' => 6,
            'facturacion' => 7,
            'caja' => 8,
            'ajustes' => 9,
            'seguridad' => 10,
            'reportes' => 11,
            'finanzas' => 12,
            'restaurante' => 13,
            'hoteleria' => 14,
        );


        //====================== MODULOS HIJOS ==================================

        // EMPRESA ********************************************

        \DB::table('system_modules')->insert([
            'name' => 'Información',
            'father_id' => $modules['empresa'],
            'position' => 1,
            'module' => 'informationcompany',
            'ui_sref' => 'company.informationcompany',
            'is_show'=>true
        ]);

        \DB::table('system_modules')->insert([
            'name' => 'Empleados',
            'father_id' => $modules['empresa'],
            'position' => 2,
            'module' => 'employees',
            'ui_sref' => 'company.employees',
            'is_show'=>true
        ]);

        \DB::table('system_modules')->insert([
            'name' => 'Puestos trabajo',
            'father_id' => $modules['empresa'],
            'position' => 3,
            'module' => 'jobs',
            'ui_sref' => 'company.jobs',
            'is_show'=>true
        ]);

        \DB::table('system_modules')->insert([
            'name' => 'Colaboradores',
            'father_id' => $modules['empresa'],
            'position' => 2,
            'module' => 'collaborators',
            'ui_sref' => 'company.collaborators',
            'is_show'=>true
        ]);


        // CATALOGO *************************************************

        \DB::table('system_modules')->insert([
            'name' => 'Servicios',
            'father_id' => $modules['catalogo'],
            'position' => 1,
            'module' => 'servicesproduct',
            'ui_sref' => 'catalog.servicesproduct',
            'is_show'=>true
        ]);

        \DB::table('system_modules')->insert([
            'name' => 'Productos',
            'father_id' => $modules['catalogo'],
            'position' => 1,
            'module' => 'products',
            'ui_sref' => 'catalog.products',
        ]);

        \DB::table('system_modules')->insert([
            'name' => 'Marcas',
            'father_id' => $modules['catalogo'],
            'position' => 2,
            'module' => 'brands',
            'ui_sref' => 'catalog.brands',
        ]);

        \DB::table('system_modules')->insert([
            'name' => 'Categorías',
            'father_id' => $modules['catalogo'],
            'position' => 3,
            'module' => 'categories',
            'ui_sref' => 'catalog.categories',
        ]);

        \DB::table('system_modules')->insert([
            'name' => 'Líneas categorías',
            'father_id' => $modules['catalogo'],
            'position' => 4,
            'module' => 'lines',
            'ui_sref' => 'catalog.lines',
        ]);

        \DB::table('system_modules')->insert([
            'name' => 'Variantes',
            'father_id' => $modules['catalogo'],
            'position' => 5,
            'module' => 'variants',
            'ui_sref' => 'catalog.variants',
            'is_show'=>true
        ]);


        // ALMACENES
        \DB::table('system_modules')->insert([
            'name' => 'Almacenes',
            'father_id' => $modules['almacen'],
            'position' => 1,
            'module' => 'warehouses',
            'ui_sref' => 'warehouse.warehouses',
            'is_show'=>false
        ]);

        \DB::table('system_modules')->insert([
            'name' => 'Entradas',
            'father_id' => $modules['almacen'],
            'position' => 2,
            'module' => 'entry',
            'ui_sref' => 'warehouse.entry',
        ]);

        \DB::table('system_modules')->insert([
            'name' => 'Salidas',
            'father_id' => $modules['almacen'],
            'position' => 3,
            'module' => 'output',
            'ui_sref' => 'warehouse.output',
        ]);

        \DB::table('system_modules')->insert([
            'name' => 'Traspasos almacen',
            'father_id' => $modules['almacen'],
            'position' => 4,
            'module' => 'transfers',
            'ui_sref' => 'warehouse.transfers',
        ]);

        \DB::table('system_modules')->insert([
            'name' => 'Stock productos',
            'father_id' => $modules['almacen'],
            'position' => 5,
            'module' => 'stockgeneral',
            'ui_sref' => 'warehouse.stockgeneral',
        ]);


        // COMPRAS ***********************************************

        \DB::table('system_modules')->insert([
            'name' => 'Proveedores',
            'father_id' => $modules['compras'],
            'position' => 1,
            'module' => 'providers',
            'ui_sref' => 'purchase.providers',
        ]);

        \DB::table('system_modules')->insert([
            'name' => 'Compras',
            'father_id' => $modules['compras'],
            'position' => 2,
            'module' => 'purchases',
            'ui_sref' => 'purchase.purchases',
        ]);

        \DB::table('system_modules')->insert([
            'name' => 'Orden compra',
            'father_id' => $modules['compras'],
            'position' => 3,
            'module' => 'orderspurchases',
            'ui_sref' => 'purchase.orderspurchases',
            'is_show'=>true
        ]);

        // FACTURACIÓN *************************************************

        \DB::table('system_modules')->insert([
            'name' => 'Comprobantes',
            'father_id' => $modules['facturacion'],
            'position' => 1,
            'module' => 'vouchers',
            'ui_sref' => 'billing.vouchers',
        ]);

        \DB::table('system_modules')->insert([
            'name' => 'Nota de Crédito',
            'father_id' => $modules['facturacion'],
            'position' => 2,
            'module' => 'creditnotes',
            'ui_sref' => 'billing.creditnotes',
        ]);

        \DB::table('system_modules')->insert([
            'name' => 'Nota de Débito',
            'father_id' => $modules['facturacion'],
            'position' => 3,
            'module' => 'debitnotes',
            'ui_sref' => 'billing.debitnotes',
            'is_show'=>false
        ]);

        \DB::table('system_modules')->insert([
            'name' => 'Guía de remisión',
            'father_id' => $modules['facturacion'],
            'position' => 4,
            'module' => 'referralguide',
            'ui_sref' => 'billing.referralguide',
            'is_show'=>true
        ]);



        // VENTAS *************************************************

        \DB::table('system_modules')->insert([
            'name' => 'Clientes',
            'father_id' => $modules['ventas'],
            'position' => 1,
            'module' => 'clients',
            'ui_sref' => 'sales.clients',
        ]);

        \DB::table('system_modules')->insert([
            'name' => 'Comandas',
            'father_id' => $modules['ventas'],
            'position' => 2,
            'module' => 'eatery',
            'ui_sref' => 'sales.eatery',
            'is_show'=>true
        ]);

        \DB::table('system_modules')->insert([
            'name' => 'Ventas',
            'father_id' => $modules['ventas'],
            'position' => 2,
            'module' => 'sale',
            'ui_sref' => 'sales.sale',
        ]);

        \DB::table('system_modules')->insert([
            'name' => 'Proformas',
            'father_id' => $modules['ventas'],
            'position' => 3,
            'module' => 'proformas',
            'ui_sref' => 'sales.proformas',
            'is_show'=>true
        ]);

        //
        \DB::table('system_modules')->insert([
            'name' => 'Pedidos',
            'father_id' => $modules['ventas'],
            'position' => 2,
            'module' => 'orders',
            'ui_sref' => 'sales.orders',
        ]);

        \DB::table('system_modules')->insert([
            'name' => 'Gestión servicios',
            'father_id' => $modules['ventas'],
            'position' => 1,
            'module' => 'saleservices',
            'ui_sref' => 'sales.saleservices',
        ]);

        // CAJA *********************************************

        \DB::table('system_modules')->insert([
            'name' => 'Apertura',
            'father_id' => $modules['caja'],
            'position' => 1,
            'module' => 'opening',
            'ui_sref' => 'money.opening',
        ]);

        \DB::table('system_modules')->insert([
            'name' => 'Movimientos caja',
            'father_id' => $modules['caja'],
            'position' => 2,
            'module' => 'moneymovements',
            'ui_sref' => 'money.moneymovements',
            'is_show'=>true
        ]);

        \DB::table('system_modules')->insert([
            'name' => 'Cobros pendientes',
            'father_id' => $modules['caja'],
            'position' => 3,
            'module' => 'charges',
            'ui_sref' => 'money.charges',
            'is_show'=>true
        ]);

        \DB::table('system_modules')->insert([
            'name' => 'Ingresos',
            'father_id' => $modules['caja'],
            'position' => 4,
            'module' => 'incomes',
            'ui_sref' => 'money.incomes',
        ]);

        \DB::table('system_modules')->insert([
            'name' => 'Egresos',
            'father_id' => $modules['caja'],
            'position' => 5,
            'module' => 'expenses',
            'ui_sref' => 'money.expenses',
            'is_show'=>true
        ]);

        \DB::table('system_modules')->insert([
            'name' => 'Historial cajas',
            'father_id' => $modules['caja'],
            'position' => 6,
            'module' => 'historybox',
            'ui_sref' => 'money.historybox',
            'is_show'=>true
        ]);

        \DB::table('system_modules')->insert([
            'name' => 'Pagos pendientes',
            'father_id' => $modules['caja'],
            'position' => 7,
            'module' => 'pendingpayments',
            'ui_sref' => 'money.pendingpayments',
            'is_show'=>true
        ]);


        // AJUSTES *********************************************
        \DB::table('system_modules')->insert([
            'name' => 'Generales',
            'father_id' => $modules['ajustes'],
            'position' => 1,
            'module' => 'settinggeneral',
            'ui_sref' => 'setting.settinggeneral',
            'is_show'=>true
        ]);


        // SEGURIDAD
        \DB::table('system_modules')->insert([
            'name' => 'Usuarios',
            'father_id' => $modules['seguridad'],
            'position' => 1,
            'module' => 'users',
            'ui_sref' => 'security.users',
            'is_show'=>true
        ]);

        // REPORTES
        \DB::table('system_modules')->insert([
            'name' => 'Catálogos',
            'father_id' => $modules['reportes'],
            'position' => 1,
            'module' => 'rcatalog',
            'ui_sref' => 'report.rcatalog',
            'is_show'=>true
        ]);

        \DB::table('system_modules')->insert([
            'name' => 'Ventas',
            'father_id' => $modules['reportes'],
            'position' => 2,
            'module' => 'rsale',
            'ui_sref' => 'report.rsale',
            'is_show'=>true
        ]);

        \DB::table('system_modules')->insert([
            'name' => 'Compras',
            'father_id' => $modules['reportes'],
            'position' => 3,
            'module' => 'rpurchase',
            'ui_sref' => 'report.rpurchase',
            'is_show'=>true
        ]);

        \DB::table('system_modules')->insert([
            'name' => 'Contabilidad',
            'father_id' => $modules['reportes'],
            'position' => 4,
            'module' => 'raccounting',
            'ui_sref' => 'report.raccounting',
            'is_show'=>true
        ]);

        \DB::table('system_modules')->insert([
            'name' => 'Cajas',
            'father_id' => $modules['reportes'],
            'position' => 4,
            'module' => 'rmoney',
            'ui_sref' => 'report.rmoney',
            'is_show'=>true
        ]);

        // FINANZAS
        \DB::table('system_modules')->insert([
            'name' => 'Bancos',
            'father_id' => $modules['finanzas'],
            'position' => 1,
            'module' => 'banks',
            'ui_sref' => 'finance.banks',
            'is_show'=>true
        ]);

        \DB::table('system_modules')->insert([
            'name' => 'Cuentas bancarias',
            'father_id' => $modules['finanzas'],
            'position' => 1,
            'module' => 'accountbanks',
            'ui_sref' => 'finance.accountbanks',
            'is_show'=>true
        ]);

        \DB::table('system_modules')->insert([
            'name' => 'Movimiento cuentas',
            'father_id' => $modules['finanzas'],
            'position' => 1,
            'module' => 'movementsaccounts',
            'ui_sref' => 'finance.movementsaccounts',
            'is_show'=>true
        ]);

        // ENCUESTAS  TEMPORAL
        \DB::table('system_modules')->insert([
            'name' => 'ENCUESTAS',
            'position' => 6,
            'father_url' => 'dashboard',
            'module' => 'survey',
            'ui_sref' => 'survey.poll',
            'icon' => 'fas fa-file-alt',
            'is_show'=>true
        ]);

        // RESTAURANTE *************************************************

        \DB::table('system_modules')->insert([
            'name' => 'Categoría platos',
            'father_id' => $modules['restaurante'],
            'position' => 1,
            'module' => 'categoryfood',
            'ui_sref' => 'restaurant.categoryfood',
            'is_show'=>false
        ]);

        // HOTELERIA *************************************************

        \DB::table('system_modules')->insert([
            'name' => 'Tipo Habitaciones',
            'father_id' => $modules['hoteleria'],
            'position' => 1,
            'module' => 'roomtypes',
            'ui_sref' => 'hotel.roomtypes',
            'is_show'=>true
        ]);
        \DB::table('system_modules')->insert([
            'name' => 'Habitaciones',
            'father_id' => $modules['hoteleria'],
            'position' => 1,
            'module' => 'bedrooms',
            'ui_sref' => 'hotel.bedrooms',
            'is_show'=>true
        ]);
        \DB::table('system_modules')->insert([
            'name' => 'Reservas',
            'father_id' => $modules['hoteleria'],
            'position' => 1,
            'module' => 'bookings',
            'ui_sref' => 'hotel.bookings',
            'is_show'=>true
        ]);
        \DB::table('system_modules')->insert([
            'name' => 'Planing',
            'father_id' => $modules['hoteleria'],
            'position' => 1,
            'module' => 'planning',
            'ui_sref' => 'hotel.planning',
            'is_show'=>true
        ]);
        \DB::table('system_modules')->insert([
            'name' => 'Tarifas',
            'father_id' => $modules['hoteleria'],
            'position' => 1,
            'module' => 'rates',
            'ui_sref' => 'hotel.rates',
            'is_show'=>false
        ]);

    }
}
